/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.bpcrcon;

import com.ibm.hwmca.base.bpcrcon.BackupCriticalConsoleDataResourceBundle;
import com.ibm.hwmca.base.bpcrcon.BackupErrorIds;
import com.ibm.hwmca.base.bpcrcon.BackupException;
import com.ibm.hwmca.base.bpcrcon.BackupImpl;
import com.ibm.hwmca.base.bpcrcon.BackupParameterKeys;
import com.ibm.hwmca.base.bpcrcon.BackupParameters;
import com.ibm.hwmca.base.bpcrcon.BackupWorkHandler;
import com.ibm.hwmca.base.bpcrcon.ConfirmTheActionBean;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndEvent;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkThread;
import com.ibm.hwmca.xfw.pa.tasks.PanelHandler;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class BackupTasklet
extends PanelTasklet
implements ProgressEndedListener,
BackupErrorIds,
BackupParameterKeys {
    private static final String TRACE_MASKT = "XBKPTKLT";
    private static final String TRACE_MASKF = "XBKPTKLF";
    private static final String TRACE_MASKD = "XBKPTKLD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.bpcrcon.res.BackupCriticalConsoleDataRes";
    private static final String PANEL_NAME = "ConfirmTheActionPanel";
    private static final String PANEL_BEAN = "ConfirmTheActionBean";
    private boolean progressDismissed = false;
    private UserContext usercontext = null;
    private LocalizableText taskname;
    BackupImpl backupImpl = null;
    BackupParameters backupParameters = null;
    ConfirmTheActionBean backupBean = null;
    BackupTasklet currentTasklet = null;
    public static final String TERMINATE = "Terminate";
    private PanelHandler backupPanelHandler = new PanelHandler(){
        private static final String TRACE_MASKT = "XBKPTPHT";
        private static final String TRACE_MASKF = "XBKPTPHF";
        private static final String TRACE_MASKD = "XBKPTPHD";

        public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
            Trace.trace(TRACE_MASKT, "-> PanelHandler.service()");
            TaskActionEvent event = (TaskActionEvent)request.getData("event");
            if (request.isInitialRequest()) {
                ConfirmTheActionBean bean = new ConfirmTheActionBean();
                bean.setBeanName(BackupTasklet.PANEL_NAME);
                response.replace(BackupTasklet.AUIML_FILE_NAME, BackupTasklet.PANEL_NAME, bean);
            } else if (request.isDisposed() || request.isCanceled()) {
                Trace.trace(TRACE_MASKF, ">PanelHandler request.isDisposed() || request.isCanceled()");
                Trace.trace(TRACE_MASKF, "PanelHandler Issuing response.terminate()");
                response.terminate();
            } else if (event != null && event.getElementName().equals("BackupButton")) {
                Trace.trace(TRACE_MASKF, ">PanelHandler event.getElementName() is BackupButton");
                Trace.trace(TRACE_MASKF, ">PanelHandler Issuing response.noAction()");
            }
            Trace.trace(TRACE_MASKT, "<- PanelHandler.service()");
        }
    };

    public BackupTasklet() {
        Trace.trace(TRACE_MASKT, "-> BackupTasklet.BackupTasklet()");
        this.backupParameters = BackupParameters.getBackupParameters();
        this.currentTasklet = this;
        this.setExplicitTerminate(true);
        Trace.trace(TRACE_MASKT, "<- BackupTasklet.BackupTasklet()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block18: {
            Trace.trace(TRACE_MASKT, "-> BackupTasklet.service()");
            try {
                if (taskletRequest.isInitialRequest()) {
                    Trace.trace(TRACE_MASKF, "Service - taskletRequest.isInitialRequest()");
                    Trace.trace(TRACE_MASKF, "Service - issue backupPanelHandler.service(taskletRequest,taskletResponse");
                    this.backupPanelHandler.service(taskletRequest, taskletResponse);
                    break block18;
                }
                if (taskletRequest.isDisposed() || taskletRequest.isCanceled()) {
                    Trace.trace(TRACE_MASKF, "Service - taskletRequest.isDisposed() || taskletRequest.isCanceled()");
                    Trace.trace(TRACE_MASKF, "Service - issue backupPanelHandler.service(taskletRequest,taskletResponse");
                    this.backupPanelHandler.service(taskletRequest, taskletResponse);
                    break block18;
                }
                TaskActionEvent event = (TaskActionEvent)taskletRequest.getData("event");
                Trace.trace(TRACE_MASKF, "Service - Event is: " + event);
                Trace.trace(TRACE_MASKF, "Service - getElementName() is: " + event.getElementName());
                if (event.getElementName().equals("BackupButton")) {
                    Trace.trace(TRACE_MASKF, " Service - equals BackupButton");
                    Trace.trace(TRACE_MASKF, " Service - perform the Backup Critical Console Data action");
                    Trace.trace(TRACE_MASKF, " Service - call backupImpl.backupPreparation();");
                    this.backupImpl = new BackupImpl();
                    PanelTaskletProgressListener progListener = new PanelTaskletProgressListener(this.currentTasklet);
                    String id = "1";
                    try {
                        this.backupImpl.backupPreparation();
                        Trace.trace(TRACE_MASKF, "Service - completed backup preparation");
                        Trace.trace(TRACE_MASKF, "Service - Issue backupPanelHandler.service(taskletRequest,taskletResponse)");
                        this.backupPanelHandler.service(taskletRequest, taskletResponse);
                        Trace.trace(TRACE_MASKF, "Service Issued backupPanelHandler.service(taskletRequest,taskletResponse)");
                        long duration = new Long(this.backupParameters.getParm("backup.duration"));
                        LocalizableText initialText = new LocalizableText("In progress...");
                        this.taskname = new LocalizableText("Backup Console Data");
                        ObjectId[] thisId = new ObjectId[]{new ObjectId(this.currentTasklet)};
                        ProgressData[] progData = new ProgressData[]{new ProgressData(this.taskname, thisId[0], duration)};
                        ProgressStartEvent start = new ProgressStartEvent(this.taskname, progData, duration, initialText, id, (ProgressCancelListener)null, (ProgressEndedListener)this);
                        progListener.startProgress(start);
                        ProgressReportListenerImpl backupListener = new ProgressReportListenerImpl(id, thisId, progListener);
                        Trace.trace(TRACE_MASKF, "waiting for the progress window to be dismissed");
                        this.progressDismissed = false;
                        HashMap<String, BackupImpl> paramMap = new HashMap<String, BackupImpl>();
                        paramMap.put("BackupImpl", this.backupImpl);
                        BackupWorkHandler worker = new BackupWorkHandler(backupListener);
                        WorkThread.invokeAsync(worker, worker, paramMap, "buThread");
                        try {
                            Trace.trace(TRACE_MASKF, "In TRY before Sync While Try and Wait!");
                            BackupTasklet backupTasklet = this;
                            synchronized (backupTasklet) {
                                Trace.trace(TRACE_MASKF, "In SYNC before While Try and Wait!");
                                while (!this.progressDismissed) {
                                    try {
                                        Trace.trace(TRACE_MASKF, "Wait for Progress to be Dismissed");
                                        this.wait();
                                        Trace.trace(TRACE_MASKF, "Woken Up!Progress must be Dismissed!");
                                    }
                                    catch (InterruptedException exc) {
                                        Trace.trace(TRACE_MASKF, "We got interrupted - loop around.!");
                                    }
                                }
                                if (!this.progressDismissed) {
                                    while (!this.progressDismissed) {
                                        this.progressEnded(id);
                                    }
                                }
                            }
                        }
                        catch (Throwable thrown) {
                            TaskletException te = new TaskletException(thrown);
                            Trace.trace(TRACE_MASKF, "Throwable caught: " + thrown);
                            Trace.trace(TRACE_MASKF, "Throw TaskletException: " + te);
                            throw te;
                        }
                    }
                    catch (BackupException bexc) {
                        Trace.trace(TRACE_MASKF, "backup exception caught: " + bexc.getMessage());
                        BaseMessageTitle title = new BaseMessageTitle("BKP00001");
                        Object[] backupErrorMsg = new String[]{new LocalizableText("com/ibm/hwmca/base/bpcrcon/res/backupres", BackupCriticalConsoleDataResourceBundle.BackupErrors(this.backupImpl.getState())).toString()};
                        MessageText[] bmt = new BaseMessageText[]{new BaseMessageText("BKP00002", backupErrorMsg)};
                        this.showMessageBox(true, title, bmt, "ACT0201E", MsgType.ERROR_MESSAGE, null);
                    }
                    catch (Exception e) {
                        progListener.endProgress(new ProgressEndEvent(id));
                        BackupException bexc = new BackupException(e);
                        new FrameworkLog(BackupErrorIds._logInfo, 258, bexc).log();
                    }
                    Trace.trace(TRACE_MASKF, "Service - All Done!!!!!!!!!!!!");
                    Trace.trace(TRACE_MASKF, "Service - set Disposed() ");
                    Trace.trace(TRACE_MASKF, "Service - then issue backupPanelHandler.service(taskletRequest,taskletResponse)");
                    taskletRequest.setDisposed();
                    this.backupPanelHandler.service(taskletRequest, taskletResponse);
                    break block18;
                }
                Trace.trace(TRACE_MASKF, "Service - something we don't understand or a cancel");
                Trace.trace(TRACE_MASKF, "Service - set Disposed() ");
                Trace.trace(TRACE_MASKF, "Service - then issue backupPanelHandler.service(taskletRequest,taskletResponse)");
                taskletRequest.setDisposed();
                this.backupPanelHandler.service(taskletRequest, taskletResponse);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Service Exception during init: " + e);
                HException hexc = new HException(e);
                new FrameworkLog(BackupErrorIds._logInfo, 258, hexc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- BackupTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> BackupTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(BackupErrorIds._logInfo, 256, hexc).log();
        Trace.trace(TRACE_MASKT, "<- BackupTasklet.logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> BackupTasklet.progressEnded()");
        BackupTasklet backupTasklet = this;
        synchronized (backupTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- BackupTasklet.progressEnded()");
    }
}

